include config.mk
include ../gcctemplate/compile.mk
include ../gcctemplate/files.mk
include ../gcctemplate/prepare.mk

DLLDIR_S = ../../bin/$(TARGETSYS)
DLLDIR = $(subst /,$(PATHSEP),$(DLLDIR_S))
DLLPATH = $(DLLDIR_S)/decmpa.dll

DLLLIBDIR_S = ../../lib/$(TARGETSYS)
DLLLIBDIR = $(subst /,$(PATHSEP),$(DLLLIBDIR_S))
DLLLIBPATH = $(DLLLIBDIR_S)/libdecmpadll.a

dll: $(DLLPATH) $(DLLLIBPATH)

$(DLLPATH) $(DLLLIBPATH): $(OBJECTS) decmpa.def
	-$(MKDIR) $(DLLDIR)
	-$(MKDIR) $(DLLLIBDIR)
	gcc -mdll -o junk.tmp -Wl,--base-file,base.tmp $(OBJECTS)
	$(RM) junk.tmp
	dlltool --dllname $(DLLPATH) --base-file base.tmp --output-exp temp.exp --output-lib $(DLLLIBPATH) --def decmpa.def
	$(RM) base.tmp
	gcc -mdll -o $(DLLPATH) $(OBJECTS) -Wl,temp.exp
	$(RM) temp.exp

#decmpa.def: $(OBJECTS) Dummy.o
#	dlltool -z decmpa.def $(OBJECTS) Dummy.o

-include PREPARED
-include $(DEPENDS)
-include PREPARED
